using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;
using gov.va.med.vbecs.BOL;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmEditInvoiceText
	/// </summary>
	public class FrmEditInvoiceText : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		private BOL.Division _division;

		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpText;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.RichTextBox rtxtTextBox;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Label lblInvoiceText;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.HelpProvider helpProvider1;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.ComponentModel.IContainer components = null;


		#region constructors

		/// <summary>
		/// DialogResult.Abort means the Division is currently locked and cannot be used. Check before calling ShowDialog()
		/// </summary>
		public FrmEditInvoiceText()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC017CreateShipppingInvoiceTemplate;
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			
			this._division = new BOL.Division(Common.LogonUser.LogonUserDivisionCode);
			if (!this.SetLocks(this._division.DivisionGuid))
			{
				this.DialogResult = DialogResult.Abort;
				return;
			}
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC017.FrmEditInvoiceText());
			//
			rtxtTextBox.Text = BOL.OutgoingShipmentCollection.GetInvoiceText()[Common.VbecsTables.VamcDivision.InvoiceTemplateText].ToString();
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			this.IsDirty = false;
        }

		#endregion
		

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmEditInvoiceText));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpText = new System.Windows.Forms.GroupBox();
			this.lblInvoiceText = new System.Windows.Forms.Label();
			this.rtxtTextBox = new System.Windows.Forms.RichTextBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.helpProvider1 = new System.Windows.Forms.HelpProvider();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpImage.SuspendLayout();
			this.grpText.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(392, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Edit Invoice Text";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 257);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 212);
			this.grpImage.TabIndex = 4;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpText
			// 
			this.grpText.AccessibleDescription = "Invoice Text";
			this.grpText.AccessibleName = "Invoice Text";
			this.grpText.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpText.Controls.Add(this.lblInvoiceText);
			this.grpText.Controls.Add(this.rtxtTextBox);
			this.grpText.Location = new System.Drawing.Point(60, 32);
			this.grpText.Name = "grpText";
			this.grpText.Size = new System.Drawing.Size(328, 212);
			this.grpText.TabIndex = 0;
			this.grpText.TabStop = false;
			this.grpText.Enter += new System.EventHandler(this.grpText_Enter);
			// 
			// lblInvoiceText
			// 
			this.lblInvoiceText.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblInvoiceText.Location = new System.Drawing.Point(8, 12);
			this.lblInvoiceText.Name = "lblInvoiceText";
			this.lblInvoiceText.Size = new System.Drawing.Size(308, 16);
			this.lblInvoiceText.TabIndex = 0;
			this.lblInvoiceText.Text = "Invoice Text*";
			this.lblInvoiceText.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// rtxtTextBox
			// 
			this.rtxtTextBox.AccessibleDescription = "Invoice Text";
			this.rtxtTextBox.AccessibleName = "Invoice Text";
			this.rtxtTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rtxtTextBox.DetectUrls = false;
			this.rtxtTextBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.rtxtTextBox.HideSelection = false;
			this.rtxtTextBox.Location = new System.Drawing.Point(8, 28);
			this.rtxtTextBox.MaxLength = 1000;
			this.rtxtTextBox.Name = "rtxtTextBox";
			this.rtxtTextBox.Size = new System.Drawing.Size(312, 176);
			this.rtxtTextBox.TabIndex = 1;
			this.rtxtTextBox.Text = "";
			this.rtxtTextBox.TextChanged += new System.EventHandler(this.rtxtTextBox_TextChanged);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(312, 248);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			this.btnCancel.MouseHover += new System.EventHandler(this.btnCancel_MouseHover);
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.DataMember = "";
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(232, 248);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// FrmEditInvoiceText
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(392, 273);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpText);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpKeyword(this, "Edit_Invoice_Text.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(400, 300);
			this.Name = "FrmEditInvoiceText";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "VBECS - Edit Invoice Text";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmEditInvoiceText_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpText, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.grpText.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		#region events

        /// <summary>
        /// Enable the OK button and allow the user to save.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void rtxtTextBox_TextChanged(object sender, System.EventArgs e)
		{
			btnOK.EnabledButton = (this.rtxtTextBox.Text.Trim().Length>0);
			this.IsDirty = true;
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/20/2002</CreationDate>
		///
        /// <summary>
        /// Insert new text.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave(""));
			if (saveResult != DialogResult.Yes)
			{
				return;
			}
			// 11/30/2004 Added _division.RowVersion to the Parameter list.
			if (BOL.OutgoingShipmentCollection.UpdateInvoiceText(ThisUser.UserNTLoginID, rtxtTextBox.Text, Common.UpdateFunction.UC017FrmEditInvoiceText, this._division.RowVersion)) 
			{
				this.IsDirty = false;
				this.Close();

			}
			else 
			{
				GuiMessenger.ShowMessageBox(this, Common.StrRes.SysErrMsg.UC017.InvoiceTextUpdateError());
			}

		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			string caption;
			//
			if (btnOK.EnabledButton)
			{
				caption = Common.StrRes.Tooltips.Common.OKToSave().ResString;
			}
			else
			{
				if (this.IsDirty == false && this.rtxtTextBox.Text.Trim().Length > 0)
				{
					caption = Common.StrRes.Tooltips.UC017.btnOK().ResString;
				}
				else
				{
					caption = Common.StrRes.Tooltips.UC017.btnOKNoText().ResString;
				}
			}
			//
			ttToolTip.SetToolTip(btnOK,caption);
		}

		private void btnCancel_MouseHover(object sender, System.EventArgs e)
		{
			this.ttToolTip.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.ClickToDisregardChangesAndReturn().ResString);
		}


		#endregion


		#region method

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmEditInvoiceText_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnOK.EnabledButton == false)
			{
				this.btnOK_MouseHover(this, EventArgs.Empty);
				textToSpeak = this.ttToolTip.GetToolTip(btnOK);
			}

			//
			this.SpeakMessage( textToSpeak );
		}

		private void grpText_Enter(object sender, System.EventArgs e)
		{
		
		}

	}
}

